dataset_class='cmo'
gpu=0
adpt_td_weight=0.001
adpt_steps=1000
adpt_lr=0.05
cvar_alpha=0.9
use_wandb=1
adpt_td_type='qf'
export WANDB_INIT_TIMEOUT="300"

for env in CMO-HalfCheetah-v2  CMO-Swimmer-v2 CMO-Hopper-v2 CMO-Ant-v2  
do
    seed=0

    algo='Diffusion-QL'
    weight_bc_loss=50.0
    normalize_states=1
    pref_perturb_theta=0.0
    policy_freq=2
    w_step_size_final_eval=0.1
    nohup python train_eval.py \
        --env $env\
        --seed $seed \
        --dataset $dataset_class \
        --gpu $gpu \
        --use_wandb $use_wandb \
        --w_step_size_final_eval $w_step_size_final_eval\
        --pref_perturb_theta $pref_perturb_theta \
        --algo $algo\
        --normalize_states $normalize_states\
        --adpt_td_weight $adpt_td_weight\
        --adpt_lr $adpt_lr\
        --adpt_steps $adpt_steps\
        --policy_freq $policy_freq\
        --weight_bc_loss $weight_bc_loss\
        --adpt_td_type $adpt_td_type\
        --cvar_alpha $cvar_alpha\
        > logs/${env}_${dataset_type}_${seed}.txt &
    seed=$(($seed+1))

    algo='PEDA'
    normalize_states=1
    pref_perturb_theta=0.0
    w_step_size_final_eval=0.1
    time_steps=200000
    nohup python train_eval.py \
        --env $env\
        --time_steps $time_steps\
        --seed $seed \
        --dataset $dataset_class \
        --gpu $gpu \
        --use_wandb $use_wandb \
        --w_step_size_final_eval $w_step_size_final_eval\
        --pref_perturb_theta $pref_perturb_theta \
        --algo $algo\
        --normalize_states $normalize_states\
        --adpt_td_weight $adpt_td_weight\
        --adpt_lr $adpt_lr\
        --adpt_steps $adpt_steps\
        --adpt_td_type $adpt_td_type\
        --cvar_alpha $cvar_alpha\
        > logs/${env}_${dataset_type}_${seed}.txt &
    seed=$(($seed+1))

    gpu=$(($gpu+1))
done
